import com.liferay.portal.kernel.log.LogFactoryUtil
import com.liferay.portal.model.ResourceConstants
import com.liferay.portal.security.permission.ActionKeys
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil
import com.liferay.portal.service.RoleLocalServiceUtil
import com.liferay.portal.util.PortalUtil
import com.liferay.portlet.documentlibrary.model.DLFolderConstants
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil
import com.liferay.portlet.documentlibrary.model.DLFileEntryConstants
import com.liferay.portal.service.GroupLocalServiceUtil


def log = LogFactoryUtil.getLog("RemoveGuestPermissions")

def companyId = PortalUtil.defaultCompanyId
def group = GroupLocalServiceUtil.getFriendlyURLGroup(companyId, "/hub-staging")
def groupId = group.getGroupId()

log.info "groupId: ${groupId}"

def userRoleId = RoleLocalServiceUtil.getRole(companyId, "Guest").getRoleId()

log.info "userRoleId: ${userRoleId}"

/*
 * Remove permissions from the folders
 */
def updateFolder

/**
* Recursively updates the permissions for all the child folders of the folderId
*/
updateFolder =  { folderId ->
    DLFolderLocalServiceUtil.getFolders( groupId,  folderId, false).each {
    log.info "Updating folder name: ${it.name}, id: ${it.folderId}, parentId: ${it.parentFolderId}"

    try {

      ResourcePermissionLocalServiceUtil.removeResourcePermission(
                companyId,
                it.modelClassName,
                ResourceConstants.SCOPE_INDIVIDUAL,
                it.primaryKey as String,
                userRoleId,
                ActionKeys.VIEW )


        log.info "Updated folder name: ${it.name}, id: ${it.folderId}, parentId: ${it.parentFolderId}"
      } catch ( e ) {
      	log.error "Error folder on name: ${it.name}, id: ${it.folderId}, parentId: ${it.parentFolderId}"
      }

      //pass the current folder id as the parent for recursion.
      updateFolder it.folderId
    }


    DLFileEntryLocalServiceUtil.getFileEntries(groupId, folderId).each {

          try {
          log.info "Updating file name: ${it.name}, fileEntryId: ${it.fileEntryId}, title: ${it.title}"

            ResourcePermissionLocalServiceUtil.removeResourcePermission(
                      companyId,
                      DLFileEntryConstants.getClassName(),
                      ResourceConstants.SCOPE_INDIVIDUAL,
                      it.fileEntryId as String,
                      userRoleId,
                      ActionKeys.VIEW )

            log.info "Updated file name: ${it.name}, fileEntryId: ${it.fileEntryId}, title: ${it.title}"
          } catch ( e ) {
            log.error "Error file name: ${it.name}, fileEntryId: ${it.fileEntryId}, title: ${it.title}"
          }

    }


}


log.info 'Start'
log.info 'updating folders'

updateFolder 0

log.info 'Folders update completed.'
log.info 'Script execution completed.'
